/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener.service.impl;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.config.CiConfig;
import com.qaprosoft.zafira.listener.service.TestRunTypeService;
import com.qaprosoft.zafira.models.db.Initiator;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.models.dto.config.ConfigurationType;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunTypeServiceImpl
implements TestRunTypeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestRunTypeServiceImpl.class);
    private final ZafiraClient zafiraClient;

    public TestRunTypeServiceImpl(ZafiraClient zafiraClient) {
        this.zafiraClient = zafiraClient;
    }

    @Override
    public TestRunType findTestRunByCiRunId(String ciRunId) {
        HttpClient.Response<TestRunType> response = this.zafiraClient.getTestRunByCiRunId(ciRunId);
        return response.getObject();
    }

    @Override
    public TestRunType startTestRun(TestRunType testRun) {
        HttpClient.Response<TestRunType> response = this.zafiraClient.startTestRun(testRun);
        return response.getObject();
    }

    @Override
    public TestRunType rerun(TestRunType testRun, int ciBuildNumber, long suiteId, ConfigurationType configuration) {
        testRun.setBuildNumber(ciBuildNumber);
        testRun.setConfigXML(this.convertConfigurationToXML(configuration));
        testRun.setTestSuiteId(suiteId);
        return this.startTestRun(testRun);
    }

    @Override
    public boolean abort(Long testRunId) {
        return this.zafiraClient.abortTestRun(testRunId);
    }

    @Override
    public List<TestType> findTestRunResults(long id) {
        return Arrays.asList((Object[])this.zafiraClient.getTestRunResults(id).getObject());
    }

    @Override
    public TestRunType register(Long testSuiteId, Long userId, Long jobId, Long parentJobId, ConfigurationType configuration, CiConfig ciConfig, String jiraSuiteId) {
        return this.zafiraClient.registerTestRun(testSuiteId, userId, this.convertConfigurationToXML(configuration), jobId, parentJobId, ciConfig, jiraSuiteId);
    }

    @Override
    public TestRunType register(TestRunType testRun, CiConfig.BuildCase buildCase, long suiteId, long jobId, long userId, JobType parentJob, CiConfig ciConfig, String jiraSuiteId, ConfigurationType configuration) {
        TestRunType result;
        switch (buildCase) {
            case UPSTREAMTRIGGER: {
                result = this.registerTestRunUPSTREAM_JOB(suiteId, jobId, parentJob.getId(), ciConfig, jiraSuiteId, configuration);
                break;
            }
            case TIMERTRIGGER: 
            case SCMTRIGGER: {
                result = this.registerTestRunBySCHEDULER(suiteId, jobId, ciConfig, jiraSuiteId, configuration);
                break;
            }
            case MANUALTRIGGER: {
                result = this.registerTestRunByHUMAN(suiteId, jobId, userId, ciConfig, jiraSuiteId, configuration);
                break;
            }
            default: {
                throw new RuntimeException("Unable to register test run for zafira service: " + this.zafiraClient.getServiceUrl() + " due to the misses build cause: '" + (Object)((Object)buildCase) + "'");
            }
        }
        return result;
    }

    private TestRunType registerTestRunUPSTREAM_JOB(long suiteId, long jobId, long parentJobId, CiConfig ciConfig, String jiraSuiteId, ConfigurationType configuration) {
        return this.zafiraClient.registerTestRunUPSTREAM_JOB(suiteId, this.convertConfigurationToXML(configuration), jobId, parentJobId, ciConfig, Initiator.UPSTREAM_JOB, jiraSuiteId);
    }

    private TestRunType registerTestRunBySCHEDULER(long suiteId, long jobId, CiConfig ciConfig, String jiraSuiteId, ConfigurationType configuration) {
        return this.zafiraClient.registerTestRunBySCHEDULER(suiteId, this.convertConfigurationToXML(configuration), jobId, ciConfig, Initiator.SCHEDULER, jiraSuiteId);
    }

    private TestRunType registerTestRunByHUMAN(long suiteId, long jobId, long userId, CiConfig ciConfig, String jiraSuiteId, ConfigurationType configuration) {
        return this.zafiraClient.registerTestRunByHUMAN(suiteId, userId, this.convertConfigurationToXML(configuration), jobId, ciConfig, Initiator.HUMAN, jiraSuiteId);
    }

    @Override
    public TestRunType registerTestRunResults(TestRunType testRun, ConfigurationType configuration) {
        testRun.setConfigXML(this.convertConfigurationToXML(configuration));
        return this.zafiraClient.registerTestRunResults(testRun);
    }

    @Override
    public String convertConfigurationToXML(ConfigurationType config) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ConfigurationType.class}).createMarshaller();
            marshaller.marshal((Object)(config != null ? config : new ConfigurationType()), (Writer)writer);
        }
        catch (Exception e) {
            LOGGER.error("Unable to convert config to XML!", (Throwable)e);
        }
        return writer.toString();
    }
}

