/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.log;

import com.qaprosoft.zafira.client.BasicClient;
import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.listener.ZafiraEventRegistrar;
import com.qaprosoft.zafira.log.Log;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlushingLogsBuffer {
    private static final Logger log = LoggerFactory.getLogger(FlushingLogsBuffer.class);
    private static final ScheduledExecutorService FLUSH_EXECUTOR = Executors.newScheduledThreadPool(4);
    private static BasicClient API_CLIENT;
    private static final AtomicBoolean EXECUTOR_ENABLED;
    private static Queue<Log> QUEUE;
    private static final Function<LoggingEvent, Log> CONVERTER;

    public static void put(LoggingEvent event) {
        ZafiraEventRegistrar.getTest().ifPresent(testType -> {
            Log log = CONVERTER.apply(event);
            log.setTestId(testType.getId());
            QUEUE.add(log);
            if (EXECUTOR_ENABLED.compareAndSet(false, true)) {
                FlushingLogsBuffer.scheduleFlush();
            }
        });
    }

    private static void scheduleFlush() {
        FLUSH_EXECUTOR.scheduleWithFixedDelay(FlushingLogsBuffer::flush, 1L, 1L, TimeUnit.SECONDS);
    }

    private static synchronized void flush() {
        if (!QUEUE.isEmpty()) {
            ZafiraEventRegistrar.getTestRun().ifPresent(testRunType -> {
                Queue<Log> logsBatch = QUEUE;
                QUEUE = new ConcurrentLinkedQueue<Log>();
                API_CLIENT.sendLogs(logsBatch, testRunType.getId());
            });
        }
    }

    private static void shutdown() {
        FLUSH_EXECUTOR.shutdown();
        try {
            FLUSH_EXECUTOR.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        FlushingLogsBuffer.flush();
    }

    static {
        EXECUTOR_ENABLED = new AtomicBoolean();
        QUEUE = new ConcurrentLinkedQueue<Log>();
        CONVERTER = e -> Log.builder().message(e.getRenderedMessage()).level(e.getLevel().toString()).timestamp(e.getTimeStamp()).build();
        ZafiraClient zafiraClient = ZafiraSingleton.INSTANCE.getClient();
        if (ZafiraSingleton.INSTANCE.isRunning() && zafiraClient != null) {
            API_CLIENT = zafiraClient.getClient();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(FlushingLogsBuffer::shutdown));
    }
}

