/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.util;

import com.qaprosoft.zafira.config.CiConfig;
import java.util.UUID;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.SystemConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.MergeCombiner;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtil.class);
    private static final String ERR_MSG_INIT_CONFIG = "Unable to initialize a configuration '%s'";
    private static CombinedConfiguration configuration;

    public static CiConfig retrieveCiConfig(CombinedConfiguration config) {
        return new CiConfig.Builder().setCiRunId(config.getString("ci_run_id", UUID.randomUUID().toString())).setCiUrl(config.getString("ci_url", "http://localhost:8080/job/local")).setCiBuild(config.getString("ci_build", null)).setCiBuildCause(config.getString("ci_build_cause", "MANUALTRIGGER")).setCiParentUrl(config.getString("ci_parent_url", null)).setCiParentBuild(config.getString("ci_parent_build", null)).setGitBranch(config.getString("git_branch", null)).setGitCommit(config.getString("git_commit", null)).setGitUrl(config.getString("git_url", null)).build();
    }

    public static CombinedConfiguration getConfiguration() {
        return ConfigurationUtil.getConfiguration(true);
    }

    public static CombinedConfiguration getConfiguration(boolean throwExceptionOnMissing) {
        if (configuration != null) {
            return configuration;
        }
        CombinedConfiguration config = new CombinedConfiguration((NodeCombiner)new MergeCombiner());
        try {
            config.setThrowExceptionOnMissing(throwExceptionOnMissing);
            config.addConfiguration((Configuration)new SystemConfiguration());
            config.addConfiguration((Configuration)ConfigurationUtil.getZafiraPropertiesConfiguration());
        }
        catch (ConfigurationException e) {
            String message = String.format(ERR_MSG_INIT_CONFIG, "zafira.properties");
            LOGGER.error(message, (Throwable)e);
        }
        configuration = config;
        return configuration;
    }

    public static void addSystemConfiguration(String key, String value) {
        System.setProperty(key, value);
        if (configuration != null) {
            configuration.addConfiguration((Configuration)new SystemConfiguration());
        }
    }

    private static FileBasedConfiguration getZafiraPropertiesConfiguration() throws ConfigurationException {
        return (FileBasedConfiguration)new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().properties().setFileName("zafira.properties")}).getConfiguration();
    }
}

