/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.util;

import com.qaprosoft.zafira.client.BasicClient;
import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.listener.ZafiraEventRegistrar;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.UploadResult;
import com.qaprosoft.zafira.util.TestArtifactHolder;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadUtil {
    private static final Logger log = LoggerFactory.getLogger(UploadUtil.class);
    private static BasicClient API_CLIENT;

    public static void uploadScreenshot(byte[] screenshot, String name, Long capturedAtMillis, boolean asArtifact) {
        Long capturedAt = capturedAtMillis != null ? capturedAtMillis.longValue() : Instant.now().toEpochMilli();
        BiConsumer<Long, Long> screenshotUploader = (testRunId, testId) -> {
            HttpClient.Response<UploadResult> response = API_CLIENT.sendScreenshot(screenshot, (Long)testRunId, (Long)testId, capturedAt);
            boolean successStatus = String.valueOf(response.getStatus()).matches("(2..)");
            if (asArtifact && successStatus) {
                UploadResult result = response.getObject();
                TestArtifactHolder.add(new TestArtifactType(name, result.getKey(), (Long)testId));
            }
        };
        UploadUtil.executeOnRegisteredTestItem(screenshotUploader, () -> log.trace("Screenshot taken: size={}, captureAtMillis={}", (Object)screenshot.length, (Object)capturedAtMillis));
    }

    public static void uploadScreenshot(File screenshot, String name, Long capturedAtMillis, boolean asArtifact) {
        try {
            byte[] content = Files.readAllBytes(screenshot.toPath());
            UploadUtil.uploadScreenshot(content, name, capturedAtMillis, asArtifact);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void uploadArtifact(File artifact, String name) {
        BiConsumer<Long, Long> artifactUploader = (testRunId, testId) -> {
            HttpClient.Response<UploadResult> response = API_CLIENT.sendArtifact(artifact, (Long)testRunId, (Long)testId, name);
            boolean successStatus = String.valueOf(response.getStatus()).matches("(2..)");
            if (!successStatus) {
                log.trace("Unable to upload artifact: name={}", (Object)name);
            }
        };
        UploadUtil.executeOnRegisteredTestItem(artifactUploader, () -> log.trace("Artifact taken: name={}", (Object)name));
    }

    private static void executeOnRegisteredTestItem(BiConsumer<Long, Long> execution, Runnable onRegistrationSkipped) {
        if (ZafiraSingleton.INSTANCE.isRunning()) {
            ZafiraEventRegistrar.getTestRun().ifPresent(testRunType -> ZafiraEventRegistrar.getTest().ifPresent(testType -> {
                Long testRunId = testRunType.getId();
                Long testId = testType.getId();
                execution.accept(testRunId, testId);
            }));
        } else {
            onRegistrationSkipped.run();
        }
    }

    static {
        ZafiraClient zafiraClient = ZafiraSingleton.INSTANCE.getClient();
        if (ZafiraSingleton.INSTANCE.isRunning() && zafiraClient != null) {
            API_CLIENT = zafiraClient.getClient();
        }
    }
}

