/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.qas.api.AuthClientException;

public class JsonMapper {
    private static final Logger LOG = Logger.getLogger(JsonMapper.class.getName());
    private static final ObjectMapper mapper = new ObjectMapper();

    private JsonMapper() {
    }

    public static ObjectNode newNode() {
        return mapper.createObjectNode();
    }

    public static <T> T fromJson(String body, Class<T> valueType) throws IOException {
        return JsonMapper.parseJson(body, valueType);
    }

    public static <T> T parseJson(String body, Class<T> valueType) throws IOException {
        if (JsonMapper.isEmpty(body)) {
            return null;
        }
        return (T)mapper.readValue(body, valueType);
    }

    public static <T> T parseJson(String body, TypeReference<T> type) throws IOException {
        if (JsonMapper.isEmpty(body)) {
            return null;
        }
        return (T)mapper.readValue(body, type);
    }

    public static <T> T fromJson(String body, TypeReference<T> type) {
        try {
            if (JsonMapper.isEmpty(body)) {
                return null;
            }
            return (T)mapper.readValue(body, type);
        }
        catch (IOException e) {
            LOG.info("ERROR: cannot parse json" + e.getMessage());
            return null;
        }
    }

    public static ObjectNode toJsonNode(Object data) {
        if (null == data) {
            return JsonMapper.newNode();
        }
        ObjectNode node = null;
        try {
            node = (ObjectNode)mapper.valueToTree(data);
        }
        catch (IllegalArgumentException e) {
            return JsonMapper.newNode();
        }
        return node;
    }

    public static String toJson(Object data) {
        if (null == data) {
            return "";
        }
        try {
            return mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public static Map<String, Object> toMap(Object data) {
        if (null == data) {
            return Collections.emptyMap();
        }
        try {
            return (Map)mapper.convertValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private static boolean isEmpty(String s) {
        return null == s || "".equals(s);
    }

    public static String toString(InputStream stream) {
        try {
            int length;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            throw new AuthClientException("Unable to read error response: " + e.getMessage(), e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

