/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.qas.api.Credentials;
import org.qas.api.JsonMapper;
import org.qas.api.internal.PropertyContainer;

public class SimpleCredentials
extends PropertyContainer
implements Credentials,
Cloneable {
    private static final String USERNAME_RESERVED_PROPERTY = "__username__";
    private static final String PASSWORD_RESERVED_PROPERTY = "__password__";

    private SimpleCredentials() {
    }

    public SimpleCredentials(String username, char[] password) {
        this(username, new String(password));
    }

    public SimpleCredentials(String username, String password) {
        this.setProperty(USERNAME_RESERVED_PROPERTY, username);
        this.setProperty(PASSWORD_RESERVED_PROPERTY, password);
    }

    public Object getAttribute(String name) {
        return this.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        this.setProperty(name, value);
    }

    public SimpleCredentials withAttribute(String name, Object value) {
        this.setAttribute(name, value);
        return this;
    }

    public String getUsername() {
        return this.getProperty(USERNAME_RESERVED_PROPERTY).toString();
    }

    public String getPassword() {
        return this.getProperty(PASSWORD_RESERVED_PROPERTY).toString();
    }

    @Override
    public SimpleCredentials clone() {
        SimpleCredentials credentials = new SimpleCredentials();
        credentials.setPropertiesFrom(this);
        return credentials;
    }

    @Override
    public String toString() {
        ObjectNode node = JsonMapper.toJsonNode(this);
        if (null == node) {
            return "{}";
        }
        node.remove(PASSWORD_RESERVED_PROPERTY);
        return node.toString();
    }
}

