/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.ApiServiceResponse;
import org.qas.api.JsonMapper;
import org.qas.api.ResponseMetadata;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.api.transform.Unmarshaller;
import org.qas.api.transform.VoidJsonUnmarshaller;

public class JsonResponseHandler<T>
implements HttpResponseHandler<ApiServiceResponse<T>> {
    private Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller;
    private static final Logger LOG = Logger.getLogger(JsonResponseHandler.class.getName());
    public boolean needsConnectionLeftOpen = false;

    public JsonResponseHandler(Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidJsonUnmarshaller();
        }
    }

    @Override
    public ApiServiceResponse<T> handle(HttpResponse response) throws Exception {
        if (LOG.isLoggable(Level.ALL)) {
            LOG.log(Level.ALL, "Parsing service response JSON");
        }
        String data = null;
        if (this.responseUnmarshaller.isParseJson()) {
            data = JsonMapper.toString(((HttpURLConnection)response.getUnderlying()).getInputStream());
        }
        ApiServiceResponse<T> awsResponse = new ApiServiceResponse<T>();
        T result = this.responseUnmarshaller.parse(data);
        awsResponse.setResult(result);
        HashMap<String, String> metadata = new HashMap<String, String>(response.getHeaders());
        metadata.put("RequestId", this.getRequestId(response));
        awsResponse.setMetadata(new ResponseMetadata(metadata));
        return awsResponse;
    }

    protected void registerAdditionalMetadataExpressions(JsonUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.needsConnectionLeftOpen;
    }

    protected String getRequestId(HttpResponse response) {
        return response.getHeaders().get("x-qtest-request-id");
    }
}

