/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.http.basic;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.http.ExecutionContext;
import org.qas.api.internal.util.Encoders;
import org.qas.api.internal.util.Https;
import org.qas.api.internal.util.google.base.Charsets;
import org.qas.api.internal.util.google.base.Strings;

class HttpUrlConnectionFactory {
    private static final Logger LOG = Logger.getLogger(HttpUrlConnectionFactory.class.getName());
    private static final Charset DEFAULT_ENCODING = Charsets.UTF_8;

    HttpUrlConnectionFactory() {
    }

    static HttpURLConnection createHttpRequest(Request request, URI redirectUri, ClientConfiguration configuration, ExecutionContext context) {
        URI endpoint = redirectUri == null ? request.getEndpoint() : redirectUri;
        String uri = endpoint.toString();
        if (!Strings.isNullOrEmpty(request.getResourcePath())) {
            if (request.getResourcePath().startsWith("/")) {
                if (uri.endsWith("/")) {
                    uri = uri.substring(0, uri.length() - 1);
                }
            } else if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + request.getResourcePath();
        } else if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        String queryParams = Https.toQueryString(request.getParameters(), Charsets.UTF_8);
        if (!Strings.isNullOrEmpty(queryParams) && !Https.usePayloadForQueryParameters(request)) {
            uri = uri + "?" + queryParams;
        }
        HttpURLConnection connection = HttpUrlConnectionFactory.createConnection(request, uri, configuration);
        connection.setConnectTimeout(configuration.getConnectionTimeout());
        connection.setReadTimeout(configuration.getSocketTimeout());
        try {
            connection.setRequestMethod(request.getHttpMethod().name());
        }
        catch (ProtocolException pex) {
            LOG.log(Level.SEVERE, "An error occurs when setting request method: " + request.getHeaders() + "\n", pex);
        }
        switch (request.getHttpMethod()) {
            case POST: {
                if (request.getContent() == null && Strings.isNullOrEmpty(queryParams)) break;
                connection.setDoOutput(true);
                break;
            }
            case PUT: {
                if (request.getContent() == null && Strings.isNullOrEmpty(queryParams)) break;
                connection.setDoOutput(true);
                break;
            }
        }
        HttpUrlConnectionFactory.prepareHeader(connection, request, redirectUri, configuration, context);
        return connection;
    }

    private static void prepareHeader(HttpURLConnection connection, Request request, URI redirectUri, ClientConfiguration configuration, ExecutionContext context) {
        URI endpoint = redirectUri == null ? request.getEndpoint() : redirectUri;
        String host = endpoint.getHost();
        if (Https.isUsingNonDefaultPort(endpoint)) {
            host = host + ":" + endpoint.getPort();
        }
        connection.setRequestProperty("Host", host);
        Map<String, String> headers = request.getHeaders();
        for (String header : headers.keySet()) {
            if ("content-length".equals(header.toLowerCase()) || "host".equals(header.toLowerCase())) continue;
            connection.setRequestProperty(header, headers.get(header));
        }
        String contentType = headers.get("Content-Type");
        if (contentType == null || "".equals(contentType)) {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.name().toLowerCase());
        }
        if (context != null && context.getContextUserAgent() != null) {
            connection.setRequestProperty("User-Agent", HttpUrlConnectionFactory.createUserAgentString(configuration, context.getContextUserAgent()));
        }
    }

    private static String createUserAgentString(ClientConfiguration configuration, String contextUserAgent) {
        if (configuration.getUserAgent().contains(contextUserAgent)) {
            return configuration.getUserAgent();
        }
        return configuration.getUserAgent() + " " + contextUserAgent;
    }

    private static HttpURLConnection createConnection(Request request, String uri, ClientConfiguration configuration) {
        HttpURLConnection connection;
        String proxyHost = configuration.getProxyHost();
        int proxyPort = configuration.getProxyPort();
        try {
            URL url = new URL(uri);
            if (!Strings.isNullOrEmpty(proxyHost) && proxyPort > 0) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                connection = (HttpURLConnection)url.openConnection(proxy);
                final String username = configuration.getProxyUsername();
                final String password = configuration.getProxyPassword();
                final String domain = configuration.getProxyDomain();
                if (!Strings.isNullOrEmpty(username) && !Strings.isNullOrEmpty(password)) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(Strings.isNullOrEmpty(domain) ? username : domain + "\\\\" + username, password.toCharArray());
                        }
                    });
                    String upEncoder = Strings.isNullOrEmpty(domain) ? username + ':' + password : domain + "\\\\" + username + ':' + password;
                    upEncoder = new String(Encoders.base64Encode(upEncoder.getBytes()));
                    connection.setRequestProperty("Proxy-Authorization", "Basic " + upEncoder);
                }
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
        }
        catch (MalformedURLException muex) {
            throw new AssertionError((Object)muex);
        }
        catch (IOException ioex) {
            throw new AssertionError((Object)ioex);
        }
        String userAgent = configuration.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        connection.setRequestProperty("User-Agent", userAgent);
        return connection;
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustingX509TrustManager()};
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new TrustHostnameVerifier());
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Could not initialize the SSL context.", ex);
        }
    }

    private static class TrustHostnameVerifier
    implements HostnameVerifier {
        private TrustHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Verify host name: [" + s + "], peer host: [" + sslSession.getPeerHost() + "]");
            }
            return true;
        }
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X_509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X_509_CERTIFICATES;
        }
    }
}

