/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonException;
import org.qas.api.internal.util.json.JsonTokener;

public class JsonObject {
    private Map map = new HashMap();
    public static final Object NULL = new Null();

    public JsonObject() {
    }

    public JsonObject(JsonObject jo, String[] names) {
        this();
        for (int i = 0; i < names.length; ++i) {
            try {
                this.putOnce(names[i], jo.opt(names[i]));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject(JsonTokener x) throws JsonException {
        this();
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JsonObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JsonObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JsonObject(Map map) {
        if (map != null) {
            for (Map.Entry e : map.entrySet()) {
                this.map.put(e.getKey(), JsonObject.wrap(e.getValue()));
            }
        }
    }

    public JsonObject(Object bean) {
        this();
        this.populateMap(bean);
    }

    public JsonObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            try {
                this.putOpt(name, c.getField(name).get(object));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject(String source) throws JsonException {
        this(new JsonTokener(source));
    }

    public JsonObject accumulate(String key, Object value) throws JsonException {
        JsonObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof JsonArray ? new JsonArray().put(value) : value);
        } else if (o instanceof JsonArray) {
            ((JsonArray)o).put(value);
        } else {
            this.put(key, new JsonArray().put(o).put(value));
        }
        return this;
    }

    public JsonObject append(String key, Object value) throws JsonException {
        JsonObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JsonArray().put(value));
        } else if (o instanceof JsonArray) {
            this.put(key, ((JsonArray)o).put(value));
        } else {
            throw new JsonException("JsonObject[" + key + "] is not a JsonArray.");
        }
        return this;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JsonException {
        Object o = this.opt(key);
        if (o == null) {
            throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws JsonException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JsonException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.valueOf((String)o).doubleValue();
        }
        catch (Exception e) {
            throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JsonException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).intValue() : Integer.parseInt((String)o);
        }
        catch (Exception e) {
            throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not an int.");
        }
    }

    public JsonArray getJsonArray(String key) throws JsonException {
        Object o = this.get(key);
        if (o instanceof JsonArray) {
            return (JsonArray)o;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not a JsonArray.");
    }

    public JsonObject getJsonObject(String key) throws JsonException {
        Object o = this.get(key);
        if (o instanceof JsonObject) {
            return (JsonObject)o;
        }
        throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not a JsonObject.");
    }

    public long getLong(String key) throws JsonException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).longValue() : Long.parseLong((String)o);
        }
        catch (Exception e) {
            throw new JsonException("JsonObject[" + JsonObject.quote(key) + "] is not a long.");
        }
    }

    public static String[] getNames(JsonObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator i = jo.keys();
        String[] names = new String[length];
        int j = 0;
        while (i.hasNext()) {
            names[j] = (String)i.next();
            ++j;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i = 0; i < length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    public String getString(String key) throws JsonException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public JsonObject increment(String key) throws JsonException {
        Object value = this.opt(key);
        if (value == null) {
            this.put(key, 1);
        } else if (value instanceof Integer) {
            this.put(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.put(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.put(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.put(key, ((Float)value).floatValue() + 1.0f);
        } else {
            throw new JsonException("Unable to increment [" + key + "].");
        }
        return this;
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.map.keySet().iterator();
    }

    public int length() {
        return this.map.size();
    }

    public JsonArray names() {
        JsonArray ja = new JsonArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n) throws JsonException {
        if (n == null) {
            throw new JsonException("Null pointer");
        }
        JsonObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.map.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JsonArray optJsonArray(String key) {
        Object o = this.opt(key);
        return o instanceof JsonArray ? (JsonArray)o : null;
    }

    public JsonObject optJsonObject(String key) {
        Object o = this.opt(key);
        return o instanceof JsonObject ? (JsonObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o instanceof String ? o.toString() : defaultValue;
    }

    private void populateMap(Object bean) {
        Class<?> klass = bean.getClass();
        boolean includeSuperClass = klass.getClassLoader() != null;
        Method[] methods = includeSuperClass ? klass.getMethods() : klass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            try {
                Method method = methods[i];
                if (!Modifier.isPublic(method.getModifiers())) continue;
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.equals("getClass") || name.equals("getDeclaringClass") ? "" : name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                Object result = method.invoke(bean, (Object[])null);
                this.map.put(key, JsonObject.wrap(result));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JsonObject put(String key, boolean value) throws JsonException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JsonObject put(String key, Collection value) throws JsonException {
        this.put(key, new JsonArray(value));
        return this;
    }

    public JsonObject put(String key, double value) throws JsonException {
        this.put(key, new Double(value));
        return this;
    }

    public JsonObject put(String key, int value) throws JsonException {
        this.put(key, new Integer(value));
        return this;
    }

    public JsonObject put(String key, long value) throws JsonException {
        this.put(key, new Long(value));
        return this;
    }

    public JsonObject put(String key, Map value) throws JsonException {
        this.put(key, new JsonObject(value));
        return this;
    }

    public JsonObject put(String key, Object value) throws JsonException {
        if (key == null) {
            throw new JsonException("Null key.");
        }
        if (value != null) {
            JsonObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JsonObject putOnce(String key, Object value) throws JsonException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JsonException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    public JsonObject putOpt(String key, Object value) throws JsonException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public Iterator sortedKeys() {
        return new TreeSet(this.map.keySet()).iterator();
    }

    public static Object stringToValue(String s) {
        if (s.equals("")) {
            return s;
        }
        if (s.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (s.equalsIgnoreCase("null")) {
            return NULL;
        }
        char b = s.charAt(0);
        if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
            if (b == '0' && s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                try {
                    return new Integer(Integer.parseInt(s.substring(2), 16));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (s.indexOf(46) > -1 || s.indexOf(101) > -1 || s.indexOf(69) > -1) {
                    return Double.valueOf(s);
                }
                Long myLong = new Long(s);
                if (myLong == (long)myLong.intValue()) {
                    return new Integer(myLong.intValue());
                }
                return myLong;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    static void testValidity(Object o) throws JsonException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JsonException("JSON does not allow non-finite numbers.");
        }
    }

    public JsonArray toJsonArray(JsonArray names) throws JsonException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JsonArray ja = new JsonArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JsonObject.quote(o.toString()));
                sb.append(':');
                sb.append(JsonObject.valueToString(this.map.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JsonException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JsonException {
        int n = this.length();
        if (n == 0) {
            return "{}";
        }
        Iterator keys = this.sortedKeys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JsonObject.quote(o.toString()));
            sb.append(": ");
            sb.append(JsonObject.valueToString(this.map.get(o), indentFactor, indent));
        } else {
            int j;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(JsonObject.quote(o.toString()));
                sb.append(": ");
                sb.append(JsonObject.valueToString(this.map.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (j = 0; j < indent; ++j) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws JsonException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JsonObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JsonObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JsonArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JsonArray(value).toString();
        }
        return JsonObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws JsonException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof Number) {
            return JsonObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JsonObject) {
            return ((JsonObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JsonArray) {
            return ((JsonArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JsonObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JsonArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JsonArray(value).toString(indentFactor, indent);
        }
        return JsonObject.quote(value.toString());
    }

    static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NULL;
            }
            if (object instanceof JsonObject || object instanceof JsonArray || NULL.equals(object) || object instanceof String || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double) {
                return object;
            }
            if (object instanceof Collection) {
                return new JsonArray((Collection)object);
            }
            if (object.getClass().isArray()) {
                return new JsonArray(object);
            }
            if (object instanceof Map) {
                return new JsonObject((Map)object);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new JsonObject(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Writer write(Writer writer) throws JsonException {
        try {
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JsonObject.quote(k.toString()));
                writer.write(58);
                Object v = this.map.get(k);
                if (v instanceof JsonObject) {
                    ((JsonObject)v).write(writer);
                } else if (v instanceof JsonArray) {
                    ((JsonArray)v).write(writer);
                } else {
                    writer.write(JsonObject.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JsonException(exception);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

