/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.api.internal.util.UniqueKeys;
import org.qas.api.support.RequestSupport;
import org.qas.api.transform.Marshaller;
import org.qas.qtest.api.services.common.PagingRequest;

public abstract class AbstractMarshaller<T extends Request, R extends ApiServiceRequest>
implements Marshaller<T, R> {
    @Override
    public T marshall(R in) throws Exception {
        this.validateRequest(in);
        RequestSupport request = new RequestSupport((ApiServiceRequest)in, this.getServiceName());
        request.setHeader("x-qtest-action", this.getActionName());
        request.setHeader("x-qtest-api-version", "V3");
        request.setHeader("x-qtest-nonce", UniqueKeys.generateNonce());
        request.setHeader("x-qtest-service-name", this.getServiceName());
        request.setHeader("Content-Type", "application/json;charset=UTF-8");
        request.setHeader("Accept", "application/json;charset=UTF-8");
        StringBuilder rpBuilder = this.getResourcePath(in, new StringBuilder());
        request.setResourcePath(rpBuilder.toString());
        String content = this.getContent(in);
        if (null != content) {
            request.setContent(new StringInputStream(content));
        }
        this.build(request, in);
        return (T)request;
    }

    public boolean isParseJson() {
        return true;
    }

    protected abstract void validateRequest(R var1) throws Exception;

    protected void build(T request, R in) {
        request.setHttpMethod(HttpMethod.GET);
    }

    protected abstract String getServiceName();

    protected abstract String getActionName();

    protected abstract String getContent(R var1) throws Exception;

    protected abstract StringBuilder getResourcePath(R var1, StringBuilder var2);

    protected StringBuilder buildPaging(StringBuilder rpBuilder, PagingRequest in) {
        if (in.getPage() > 0) {
            rpBuilder.append("?page=" + in.getPage());
            if (in.getPageSize() > 0) {
                rpBuilder.append("&pageSize=" + in.getPageSize());
            }
        } else if (in.getPageSize() > 0) {
            rpBuilder.append("?pageSize=" + in.getPageSize());
        }
        return rpBuilder;
    }
}

