/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.qas.api.ApiServiceRequest;
import org.qas.api.ApiWebServiceClient;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.auth.Signer;
import org.qas.api.http.ExecutionContext;
import org.qas.api.http.JsonErrorResponseHandler;
import org.qas.api.http.JsonResponseHandler;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.JsonErrorUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.api.transform.Unmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTest1Signer;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;

public abstract class QTestApiWebServiceClient<T extends QTestApiWebServiceClient<T>>
extends ApiWebServiceClient<T> {
    protected QTestCredentialsProvider credentialsProvider;
    protected Signer signer;
    protected final List<Unmarshaller<AuthServiceException, JsonObject>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AuthServiceException, JsonObject>>();
    protected ExecutorService executorService;

    public QTestApiWebServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public QTestApiWebServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public QTestApiWebServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public QTestApiWebServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public QTestApiWebServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public QTestApiWebServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    protected void init() {
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        String endpoint = (String)this.configuration.getProperty("service.endpoint");
        if (endpoint == null || "".equals(endpoint.trim())) {
            endpoint = "nephele.qtestnet.com";
        }
        this.setEndpoint(endpoint);
        this.signer = new QTest1Signer();
    }

    protected <X> X invoke(Request request, Unmarshaller<X, JsonUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        QTestCredentials credentials = this.credentialsProvider.getCredentials();
        ApiServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getCredentials() != null) {
            credentials = (QTestCredentials)originalRequest.getCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonResponseHandler<X> responseHandler = new JsonResponseHandler<X>(unmarshaller);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    public QTestApiWebServiceClient<T> withEndpoint(String endpoint) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        return this;
    }

    @Override
    public void shutdown() {
        if (null != this.executorService) {
            this.executorService.shutdown();
        }
    }
}

