/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qas.api.internal.util.google.collect.Lists;
import org.qas.qtest.api.internal.model.QTestBaseModel;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.defect.model.DefectLink;

public final class AutomationTestStepLog
extends QTestBaseModel<AutomationTestStepLog> {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="status")
    private String status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="expected_result")
    private String expected;
    @JsonProperty(value="actual_result")
    private String actualResult;
    @JsonProperty(value="order")
    private Integer order;
    @JsonProperty(value="attachments")
    private List<Attachment> attachments;
    @JsonProperty(value="defects")
    private List<DefectLink> defectLinks;

    public String getDescription() {
        return this.description;
    }

    public AutomationTestStepLog setDescription(String description) {
        this.description = description;
        return this;
    }

    public AutomationTestStepLog withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public AutomationTestStepLog setStatus(String status) {
        this.status = status;
        return this;
    }

    public AutomationTestStepLog withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public String getExpected() {
        return this.expected;
    }

    public AutomationTestStepLog setExpected(String expected) {
        this.expected = expected;
        return this;
    }

    public AutomationTestStepLog withExpected(String expected) {
        this.setExpected(expected);
        return this;
    }

    public String getActualResult() {
        return this.actualResult;
    }

    public AutomationTestStepLog setActualResult(String actualResult) {
        this.actualResult = actualResult;
        return this;
    }

    public AutomationTestStepLog withActualResult(String actualResult) {
        this.setActualResult(actualResult);
        return this;
    }

    public Integer getOrder() {
        return this.order;
    }

    public AutomationTestStepLog setOrder(Integer order) {
        this.order = order;
        return this;
    }

    public AutomationTestStepLog withOrder(Integer order) {
        this.setOrder(order);
        return this;
    }

    public List<Attachment> getAttachments() {
        if (null == this.attachments) {
            return Collections.emptyList();
        }
        return this.attachments;
    }

    public AutomationTestStepLog setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public AutomationTestStepLog withAttachments(List<Attachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public AutomationTestStepLog addAttachment(Attachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(attachment);
        return this;
    }

    public List<DefectLink> getDefects() {
        if (this.defectLinks == null) {
            return Collections.emptyList();
        }
        return this.defectLinks;
    }

    public AutomationTestStepLog setDefects(List<DefectLink> defectLinks) {
        this.defectLinks = defectLinks;
        return this;
    }

    public AutomationTestStepLog withDefects(List<DefectLink> defectLinks) {
        this.setDefects(defectLinks);
        return this;
    }

    public AutomationTestStepLog addDefect(DefectLink defectLink) {
        if (this.defectLinks == null) {
            this.defectLinks = Lists.newLinkedList();
        }
        this.defectLinks.add(defectLink);
        return this;
    }

    @Override
    protected AutomationTestStepLog clone() {
        AutomationTestStepLog that = new AutomationTestStepLog();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    public String elementName() {
        return "test-step-log";
    }

    @Override
    public String jsonElementName() {
        return "test_step_log";
    }
}

