/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.GetLastLogRequest;

public final class GetLastLogRequestMarshaller
extends AbstractMarshaller<Request, GetLastLogRequest> {
    @Override
    protected void validateRequest(GetLastLogRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to marshall(...)");
        }
        if (in.getTestRunId() == null || in.getTestRunId() <= 0L) {
            throw new AuthClientException("Invalid test run id passed to marshall(...)");
        }
        if (in.getExpandOption() < 0 || in.getExpandOption() > 3) {
            throw new AuthClientException("Invalid expand option passed to marshall(...)");
        }
    }

    @Override
    protected String getServiceName() {
        return "TestExecutionService";
    }

    @Override
    protected String getActionName() {
        return "GetLastLog";
    }

    @Override
    protected String getContent(GetLastLogRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(GetLastLogRequest in, StringBuilder rpBuilder) {
        rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/test-runs/").append(in.getTestRunId()).append("/test-logs/last-run");
        if (in.hasExpandOption()) {
            StringBuilder queryBuilder = new StringBuilder();
            if (in.isExpandTestCase()) {
                queryBuilder.append("testcase");
            }
            if (in.isExpandTestStep()) {
                if (queryBuilder.length() > 0) {
                    queryBuilder.append(",");
                }
                queryBuilder.append("teststeplog.teststep");
            }
            if (queryBuilder.length() > 0) {
                rpBuilder.append("?expand=").append(queryBuilder.toString());
            }
        }
        return rpBuilder;
    }
}

