/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.GetTestRunRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestRunRequestMarshaller;

public final class GetTestRunRequestMarshaller
extends AbstractTestRunRequestMarshaller<GetTestRunRequest> {
    @Override
    public Request marshall(GetTestRunRequest getTestRunRequest) throws Exception {
        getTestRunRequest = ApiPreconditions.notNull(getTestRunRequest);
        GetTestRunRequestMarshaller.validateProjectId(getTestRunRequest.getProjectId());
        GetTestRunRequestMarshaller.validateTestRunId(getTestRunRequest.getTestRunId());
        if (getTestRunRequest.getExpandOption() < 0 || getTestRunRequest.getExpandOption() > 3) {
            throw new AuthClientException("Invalid expand option passed to marshall(...)");
        }
        Request request = this.createJsonRequest(getTestRunRequest, "GetTestRun", HttpMethod.GET);
        StringBuilder pathBuilder = this.createApiPathBuilder(getTestRunRequest.getProjectId());
        pathBuilder.append("/").append(getTestRunRequest.getTestRunId());
        if (getTestRunRequest.hasExpandOption()) {
            pathBuilder.append("?expand=");
            if (getTestRunRequest.isExpandTestStep()) {
                pathBuilder.append("testcase.teststep");
            } else if (getTestRunRequest.isExpandTestCase()) {
                pathBuilder.append("testcase");
            }
        }
        request.setResourcePath(pathBuilder.toString());
        return request;
    }
}

