/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.qas.api.DateTimeDeserializer;
import org.qas.api.DateTimeSerializer;
import org.qas.api.internal.util.google.collect.Lists;
import org.qas.qtest.api.internal.model.QTestBaseModel;
import org.qas.qtest.api.services.host.model.AutomationMaterial;
import org.qas.qtest.api.services.host.model.JobParameter;
import org.qas.qtest.api.services.host.model.Status;

public class Job
extends QTestBaseModel<Job> {
    @JsonProperty(value="start_date")
    private Date startDate;
    @JsonProperty(value="end_date")
    private Date endDate;
    @JsonProperty(value="status")
    private Status status;
    @JsonProperty(value="agent_server_id")
    private Long agentServerId;
    @JsonProperty(value="agent_id")
    private Long agentId;
    @JsonProperty(value="schedule_id")
    private Long scheduleId;
    @JsonProperty(value="scheduled_by")
    private Long scheduledBy;
    @JsonProperty(value="automation_materials")
    private List<AutomationMaterial> automationMaterials;
    @JsonProperty(value="job_id")
    private Long jobId;
    @JsonProperty(value="host_server_id")
    private Long hostServerId;
    @JsonProperty(value="project_id")
    private Long projectId;
    @JsonProperty(value="parameters")
    private JobParameter parameters;

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getStartDate() {
        return this.startDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public Job setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public Job withStartDate(Date startDate) {
        this.setStartDate(startDate);
        return this;
    }

    @JsonSerialize(using=DateTimeSerializer.class, typing=JsonSerialize.Typing.STATIC, include=JsonSerialize.Inclusion.NON_NULL)
    public Date getEndDate() {
        return this.endDate;
    }

    @JsonDeserialize(using=DateTimeDeserializer.class)
    public Job setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public Job withEndDate(Date endDate) {
        this.setEndDate(endDate);
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Job setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Job withStatus(Status status) {
        this.setStatus(status);
        return this;
    }

    public Long getAgentServerId() {
        return this.agentServerId;
    }

    public Job setAgentServerId(Long id) {
        this.agentServerId = id;
        return this;
    }

    public Job withAgentServerId(Long id) {
        this.setAgentServerId(id);
        return this;
    }

    public Long getAgentId() {
        return this.agentId;
    }

    public Job setAgentId(Long id) {
        this.agentId = id;
        return this;
    }

    public Job withAgentId(Long id) {
        this.setAgentId(id);
        return this;
    }

    public Long getScheduleId() {
        return this.scheduleId;
    }

    public Job setScheduleId(Long id) {
        this.scheduleId = id;
        return this;
    }

    public Job withScheduleId(Long id) {
        this.setScheduleId(id);
        return this;
    }

    public List<AutomationMaterial> getAutomationMaterials() {
        if (this.automationMaterials == null) {
            return Collections.emptyList();
        }
        return this.automationMaterials;
    }

    public Job setAutomationMaterials(List<AutomationMaterial> automationMaterials) {
        this.automationMaterials = automationMaterials;
        return this;
    }

    public Job withAutomationMaterials(List<AutomationMaterial> automationMaterials) {
        this.setAutomationMaterials(automationMaterials);
        return this;
    }

    public Job addAutomationMaterial(AutomationMaterial automationMaterial) {
        if (this.automationMaterials == null) {
            this.automationMaterials = Lists.newLinkedList();
        }
        this.automationMaterials.add(automationMaterial);
        return this;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Job setJobId(Long jobId) {
        this.jobId = jobId;
        return this;
    }

    public Job withJobId(Long jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Long getHostServerId() {
        return this.hostServerId;
    }

    public Job setHostServerId(Long hostServerId) {
        this.hostServerId = hostServerId;
        return this;
    }

    public Job withHostServerId(Long hostServerId) {
        this.setHostServerId(hostServerId);
        return this;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Job setProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public Long getScheduledBy() {
        return this.scheduledBy;
    }

    public Job setScheduledBy(Long scheduledBy) {
        this.scheduledBy = scheduledBy;
        return this;
    }

    public Job withProjectId(Long projectId) {
        this.setProjectId(projectId);
        return this;
    }

    public JobParameter getParameters() {
        return this.parameters;
    }

    public void setParameters(JobParameter parameters) {
        this.parameters = parameters;
    }

    @Override
    protected Job clone() {
        Job copy = new Job();
        copy.setPropertiesFrom(this);
        return copy;
    }

    @Override
    public String elementName() {
        return "job";
    }

    @Override
    public String jsonElementName() {
        return "job";
    }
}

