package org.qas.api.handler;

import org.qas.api.ApiServiceRequest;

/**
 * AsyncHandler
 *
 * @author: Dzung Nguyen
 * @version: $Id AsyncHandler 2014-03-26 15:36:30z dungvnguyen $
 * @since 1.0
 */
public interface AsyncHandler<Request extends ApiServiceRequest, Result> {
  /**
   * Invoked after asynchronous request.
   *
   * @param ex the exception was thrown.
   */
  void onError(Exception ex);

  /**
   * Invoked after an asynchronous request has completed successfully. Callers
   * have access to the original request object and the returned response
   * object.
   *
   * @param request
   *            The initial request created by the caller
   * @param result
   *            The successful result of the executed operation.
   */
  void onSuccess(Request request, Result result);
}
