package org.qas.api.http;

/**
 * HttpResponseHandler
 *
 * @author: Dzung Nguyen
 * @version: $Id HttpResponseHandler 2014-03-26 17:29:30z dungvnguyen $
 * @since 1.0
 */
public interface HttpResponseHandler<T> {
  /**
   * Accepts an HTTP response object, and returns an object of type T.
   *
   * @param response The HTTP response to handle, as received from request.
   * @return An object of type T, as defined by individual implementation.
   * @throws Exception If any problems are encountered handling the response.
   */
  T handle(HttpResponse<?> response) throws Exception;

  /**
   * @return {@code true} if this response handler requires that the
   *         underlying HTTP connection be left open, and not automatically
   *         closed, otherwise false.
   */
  boolean needsConnectionLeftOpen();
}
