/*
 * Copyright (c) 2002 JSON.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * The Software shall be used for Good, not Evil.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.qas.api.internal.util.json;

/**
 * The JsonException is thrown by the JSON.org classes when things are amiss.
 *
 * @author Dzung Nguyen
 * @version $Id JsonException 2014-03-27 09:41:30z dungvnguyen $
 * @since 1.0
 */
public class JsonException extends Exception {
  //~ class properties ========================================================
  private static final long serialVersionUID = 3001080562805463366L;

  //~ class members ===========================================================
  /**
   * Constructs a JsonException with an explanatory message.
   *
   * @param message Detail about the reason for the exception.
   */
  public JsonException(String message) {
    super(message);
  }

  /**
   * Constructs a JsonException with an the cause of exception.
   *
   * @param cause the cause of exception.
   */
  public JsonException(Throwable cause) {
    super(cause.getMessage(), cause);
  }
}
