package org.qas.qtest.api.auth;

import org.qas.api.AuthClientException;
import org.qas.api.Credentials;
import org.qas.api.Request;
import org.qas.api.auth.AbstractSigner;
import org.qas.api.internal.util.Encoders;

/**
 * AbstractQTestSigner
 *
 * @author Dzung Nguyen
 * @version $Id AbstractQTestSigner 2014-03-27 14:37:30z dungvnguyen $
 * @since 1.0
 */
public abstract class AbstractQTestSigner extends AbstractSigner {
  //~ class members ===========================================================
  public final void sign(Request request, Credentials credentials) {
    if (credentials instanceof QTestCredentials) {
      QTestCredentials sanitizeCredentials = sanitizeCredentials((QTestCredentials) credentials);
      sign(request, sanitizeCredentials);
    } else {
      throw new AuthClientException("The credentials you provider is invalid");
    }
  }

  protected QTestCredentials sanitizeCredentials(QTestCredentials credentials) {
    String token = null;
    synchronized (credentials) {
      token = credentials.getToken();
    }

    if (token != null) token = token.trim();
    return new BasicQTestCredentials(token);
  }

  protected String getCanonicalizedResourcePath(Request request) {
    String resourcePath = "";

    // append path from end-point.
    if (request.getEndpoint().getPath() != null) {
      resourcePath += request.getEndpoint().getPath();
    }

    if (resourcePath.endsWith("/")) {
      resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
    }

    // compute the resource path.
    if (request.getResourcePath() != null) {
      if (resourcePath.length() > 0 &&
          !resourcePath.endsWith("/") &&
          !request.getResourcePath().startsWith("/")) {
        resourcePath += "/";
      }

      resourcePath += request.getResourcePath();
    }

    if (!resourcePath.startsWith("/")) {
      resourcePath = "/" + resourcePath;
    }

    if (resourcePath.startsWith("//")) {
      resourcePath = resourcePath.substring(1);
    }

    return resourcePath;
  }

  @Override
  protected final String base64(byte[] source) {
    return Encoders.base64UrlEncodeText(source);
  }

  /**
   * Sign the qTest request.
   *
   * @param request the given qTest request.
   * @param credentials the qTest credentials used to sign request.
   */
  protected abstract void sign(Request request, QTestCredentials credentials);
}
