package org.qas.qtest.api.auth;

/**
 * StaticQTestCredentialsProvider
 *
 * @author Dzung Nguyen
 * @version $Id StaticQTestCredentialsProvider 2014-03-27 21:33:30z dungvnguyen $
 * @since 1.0
 */
public class StaticQTestCredentialsProvider implements QTestCredentialsProvider {
  //~ class properties ========================================================
  private final QTestCredentials credentials;

  //~ class members ===========================================================
  /**
   * Constructs StaticQTestCredentialsProvider from the given {@link QTestCredentials} object.
   *
   * @param credentials the given {@link QTestCredentials} object.
   */
  public StaticQTestCredentialsProvider(QTestCredentials credentials) {
    this.credentials = credentials;
  }

  @Override
  public QTestCredentials getCredentials() {
    return credentials;
  }

  @Override
  public void refresh() {}
}
