package org.qas.qtest.api.internal.model;

/**
 * FieldType
 *
 * @author Dzung Nguyen
 * @version $Id FieldType 2014-07-11 00:38:30z dungvnguyen $
 * @since 1.0
 */
public enum ObjectType {
  Release("releases"),
  Build("builds"),
  Requirement("requirements"),
  TestCase("test-cases"),
  TestCycle("test-cycles"),
  TestStep("test-steps"),
  TestSuite("test-suites"),
  TestRun("test-runs"),
  TestLog("test-logs"),
  Defect("defects");

  //~ class properties ========================================================
  private String path;

  //~ class members ===========================================================
  ObjectType(String path) {
    this.path = path;
  }

  /**
   * @return the field's relative path.
   */
  public String getPath() {
    return path;
  }
}
