package org.qas.qtest.api.services.attachment;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.attachment.model.Attachment;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;

/**
 * AttachmentService
 *
 * @author Dzung Nguyen
 * @version $Id AttachmentService 2014-03-28 06:22:30z dungvnguyen $
 * @since 1.0
 */
public interface AttachmentService extends QTestService {
  /**
   * Attaches data to qTest service.
   *
   * @param attachmentRequest the given {@link AttachmentRequest attachment request}
   * @return the attachment instance.
   * @throws AuthServiceException if an error occurs during attach data to qTest service.
   */
  Attachment attach(AttachmentRequest attachmentRequest) throws AuthServiceException;
}
