package org.qas.qtest.api.services.authenticate;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.authenticate.model.*;
import org.qas.qtest.api.services.user.model.User;

/**
 * AuthenticateService
 *
 * @author Dzung Nguyen
 * @version $Id AuthenticateService 2014-07-09 11:15:30z dungvnguyen $
 * @since 1.0
 */
public interface AuthenticateService extends QTestService {
  /**
   * Authenticate the given request and return the token.
   *
   * @param request the given authenticate request to authenticate.
   * @return the authenticate token.
   * @throws org.qas.api.AuthServiceException if an error occurs during authenticate.
   */
  String authenticate(AuthenticateRequest request) throws AuthServiceException;

  /**
   * Validate the token from the given token request.
   *
   * @param request the given validate token request to validate.
   * @return the user information.
   * @throws AuthServiceException if an error occurs during validate.
   */
  User validate(ValidateTokenRequest request) throws AuthServiceException;

  /**
   * Authenticate the given OAuth request.
   *
   * @param request the given OAuth request.
   * @return the {@link OAuthTokenResponse OAuth token response}
   * @throws AuthServiceException if an error occurs during authenticate.
   */
  OAuthTokenResponse authenticate(OAuthAuthenticateRequest request) throws AuthServiceException;

  /**
   * Request token status.
   *
   * @param statusRequest the given status request.
   * @return the {@link OAuthTokenStatusResponse OAuth status response}
   * @throws AuthServiceException if  an error occurs during request status.
   */
  OAuthTokenStatusResponse status(OAuthTokenStatusRequest statusRequest) throws AuthServiceException;

  /**
   * Refresh token.
   *
   * @param refreshRequest the given refresh request.
   * @return the {@link OAuthTokenStatusResponse OAuth status response}
   * @throws AuthServiceException if  an error occurs during refresh token.
   */
  OAuthTokenStatusResponse refresh(OAuthTokenRefreshRequest refreshRequest) throws AuthServiceException;
}
