package org.qas.qtest.api.services.authenticate.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * OAuthTokenStatusResponse
 *
 * @author Dzung Nguyen
 * @version $Id OAuthTokenStatusResponse 2016-11-29 06:19:30z dzungvnguyen $
 * @since 1.0
 */
public final class OAuthTokenStatusResponse extends QTestBaseModel<OAuthTokenStatusResponse> {
  @JsonProperty("expiration")
  private Long expiration;
  @JsonProperty("validityInMilliseconds")
  private Long validityInMilliseconds;

  /**
   * Creates {@link OAuthTokenStatusResponse} instance.
   */
  public OAuthTokenStatusResponse() {
  }

  /**
   * Obtains the expiration.
   *
   * @return the expiration.
   */
  public Long getExpiration() {
    return expiration;
  }

  /**
   * Obtains the validityInMilliseconds.
   *
   * @return the validityInMilliseconds.
   */
  public Long getValidityInMilliseconds() {
    return validityInMilliseconds;
  }

  @Override
  public OAuthTokenStatusResponse clone() {
    OAuthTokenStatusResponse that = new OAuthTokenStatusResponse();
    that.setPropertiesFrom(this);
    return that;
  }
}
