package org.qas.qtest.api.services.client;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.client.model.Client;
import org.qas.qtest.api.services.client.model.GetClientRequest;
import org.qas.qtest.api.services.client.model.SetSessionUrlRequest;

/**
 * ClientService
 *
 * @author Dzung Nguyen
 * @version $Id ClientService 2014-11-11 13:45:30z dungvnguyen $
 * @since 1.0
 */
public interface ClientService extends QTestService {
  /**
   * Get client from the given {@link GetClientRequest client request} instance.
   *
   * @param getClientRequest the given {@link GetClientRequest client request} instance.
   * @return the {@link Client} instance.
   * @throws AuthServiceException if an error occurs during getting client.
   */
  Client getClient(GetClientRequest getClientRequest) throws AuthServiceException;

  /**
   * Sets session URL from the given {@link SetSessionUrlRequest request} instance.
   *
   * @param setSessionUrlRequest the given {@link SetSessionUrlRequest set session URL request} instance.
   * @throws AuthServiceException if an error occurs during setting session URL.
   */
  void setSessionUrl(SetSessionUrlRequest setSessionUrlRequest) throws AuthServiceException;
}
