package org.qas.qtest.api.services.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * Client
 *
 * @author Dzung Nguyen
 * @version $Id Client 2014-11-11 14:10:30z dungvnguyen $
 * @since 1.0
 */
public final class Client extends QTestBaseModel<Client> {

  @JsonProperty("client_site")
  private String clientSite;

  /**
   * Creates {@link Client} instance.
   */
  public Client() {
  }

  /**
   * @return the client site.
   */
  public String getClientSite() {
    return clientSite;
  }

  /**
   * Sets client site from the given client site value.
   *
   * @param clientSite the given client site value to set.
   */
  public Client setClientSite(String clientSite) {
    this.clientSite = clientSite;
    return this;
  }

  /**
   * Sets client site from the given client site value.
   *
   * @param clientSite the given client site value to set.
   * @return the {@link Client} object.
   */
  public Client withClientSite(String clientSite) {
    setClientSite(clientSite);
    return this;
  }

  @Override
  public Client clone() {
    Client that = new Client();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "client";
  }
}
