package org.qas.qtest.api.services.defect;

import org.qas.api.AuthServiceException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.services.defect.model.CreateDefectRequest;
import org.qas.qtest.api.services.defect.model.Defect;
import java.util.concurrent.Future;

/**
 * DefectServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id DefectServiceAsync 2014-07-16 17:35:30z dungvnguyen $
 * @since 1.0
 */
public interface DefectServiceAsync extends DefectService {
  /**
   * Creates defect from the given {@link CreateDefectRequest} instance.
   *
   * @param createDefectRequest the given {@link CreateDefectRequest} instance.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating request.
   */
  Future<Defect> createDefectAsync(CreateDefectRequest createDefectRequest) throws AuthServiceException;

  /**
   * Creates defect from the given {@link CreateDefectRequest} instance.
   *
   * @param createDefectRequest the given {@link CreateDefectRequest} instance.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating request.
   */
  Future<Defect> createDefectAsync(CreateDefectRequest createDefectRequest,
                                   AsyncHandler<CreateDefectRequest, Defect> asyncHandler) throws AuthServiceException;

  /**
   * Creates defect comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest} instance.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating defect comment.
   */
  Future<Defect> addCommentAsync(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException;

  /**
   * Creates defect comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest} instance.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating defect comment.
   */
  Future<Defect> addCommentAsync(CreateObjectCommentRequest createObjectCommentRequest,
                                 AsyncHandler<CreateObjectCommentRequest, Defect> asyncHandler) throws AuthServiceException;
}
