package org.qas.qtest.api.services.defect.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateDefectRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateDefectRequest 2014-07-16 15:15:30z dungvnguyen $
 * @since 1.0
 */
public class CreateDefectRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Defect defect;

  //~ class members ===========================================================

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets create defect project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets create defect project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current {@link CreateDefectRequest} instance.
   */
  public CreateDefectRequest withProjectId(Long projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * @return the defect instance.
   */
  public Defect getDefect() {
    return defect;
  }

  /**
   * Sets the defect instance.
   *
   * @param defect the given defect instance to set.
   */
  public void setDefect(Defect defect) {
    this.defect = defect;
  }

  /**
   * Sets the defect instance.
   *
   * @param defect the given defect instance to set.in
   * @return current instance.
   */
  public CreateDefectRequest withDefect(Defect defect) {
    this.defect = defect;
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateDefectRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(",\n");
    sb.append("\tdefect:\n").append(defect).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
