package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestCaseRequest 2014-04-03 16:58:30z dungvnguyen $
 * @since 1.0
 */
public class GetTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCaseId;
  private Long testCaseVersion;
  private boolean includeTeststeps = false;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public GetTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public GetTestCaseRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return the test case version.
   */
  public Long getTestCaseVersion() {
    return testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   */
  public void setTestCaseVersion(Long testCaseVersion) {
    this.testCaseVersion = testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   * @return this
   */
  public GetTestCaseRequest withTestCaseVersion(Long testCaseVersion) {
    setTestCaseVersion(testCaseVersion);
    return this;
  }

  /**
   * @return {@code true} if user want include test-steps.
   */
  public boolean isIncludeTeststeps() {
    return includeTeststeps;
  }

  /**
   * Sets include test-steps flag.
   *
   * @param includeTeststeps the given include test-steps flag to set.
   */
  public void setIncludeTeststeps(boolean includeTeststeps) {
    this.includeTeststeps = includeTeststeps;
  }

  /**
   * Sets include test-steps flag.
   *
   * @param includeTeststeps the given include test-steps flag to set.
   * @return this
   */
  public GetTestCaseRequest withIncludeTeststeps(boolean includeTeststeps) {
    setIncludeTeststeps(includeTeststeps);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append(", testCaseVersion=").append(testCaseVersion);
    sb.append(", includeTeststeps=").append(includeTeststeps);
    sb.append('}');
    return sb.toString();
  }
}
