package org.qas.qtest.api.services.design.model;

import org.qas.api.ApiServiceRequest;

/**
 * GetTestStepRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestStepRequest 2014-04-04 05:35:30z dungvnguyen $
 * @since 1.0
 */
public class GetTestStepRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long testCaseId;
  private Long testCaseVersion;
  private Long testStepId;

  //~ class members ===========================================================

  /**
   * @return the current project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public GetTestStepRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public GetTestStepRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return the test case version.
   */
  public Long getTestCaseVersion() {
    return testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   */
  public void setTestCaseVersion(Long testCaseVersion) {
    this.testCaseVersion = testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   * @return this
   */
  public GetTestStepRequest withTestCaseVersion(Long testCaseVersion) {
    setTestCaseVersion(testCaseVersion);
    return this;
  }

  /**
   * @return the test step identifier.
   */
  public Long getTestStepId() {
    return testStepId;
  }

  /**
   * Sets the test step identifier.
   *
   * @param testStepId the given test step identifier to set.
   */
  public void setTestStepId(Long testStepId) {
    this.testStepId = testStepId;
  }

  /**
   * Sets the test step identifier.
   *
   * @param testStepId the given test step identifier to set.
   * @return this
   */
  public GetTestStepRequest withTestStepId(Long testStepId) {
    setTestStepId(testStepId);
    return this;
  }
}
