package org.qas.qtest.api.services.design.model;

import org.qas.api.ApiServiceRequest;

/**
 * ListTestStepRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListTestStepRequest 2014-04-04 06:35:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestStepRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long testCaseId;
  private Long testCaseVersion;
  private Boolean expandCalledTestStep = false;

  //~ class members ===========================================================

  /**
   * @return the current project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public ListTestStepRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public ListTestStepRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return the test case version.
   */
  public Long getTestCaseVersion() {
    return testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   */
  public void setTestCaseVersion(Long testCaseVersion) {
    this.testCaseVersion = testCaseVersion;
  }

  /**
   * Sets the test case version.
   *
   * @param testCaseVersion the given test case version to set.
   * @return this
   */
  public ListTestStepRequest withTestCaseVersion(Long testCaseVersion) {
    setTestCaseVersion(testCaseVersion);
    return this;
  }

  /**
   * Flag to expand information of called test case
   *
   * @return boolean
   */
  public Boolean getExpandCalledTestStep() {
    return expandCalledTestStep;
  }

  /**
   * Flag to expand information of called test case
   *
   * @param expandCalledTestStep true or false
   * @return this
   */
  public ListTestStepRequest setExpandCalledTestStep(Boolean expandCalledTestStep) {
    this.expandCalledTestStep = expandCalledTestStep;
    return this;
  }

  /**
   * Flag to expand information of called test case
   *
   * @param expandCalledTestStep true or false
   * @return this
   */
  public ListTestStepRequest withExpandCalledTestStep(Boolean expandCalledTestStep) {
    setExpandCalledTestStep(expandCalledTestStep);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListTestStepRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append(", testCaseVersion=").append(testCaseVersion);
    sb.append(", expandCalledTestStep=").append(expandCalledTestStep);
    sb.append('}');
    return sb.toString();
  }
}
