package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthServiceException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.model.transform.AbstractQTestApiRequestMarshaller;

/**
 * AbstractTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AbstractTestCaseRequestMarshaller 2015-06-03 14:56:30z dzungvnguyen $
 * @since 1.0
 */
public abstract class AbstractTestCaseRequestMarshaller<T extends ApiServiceRequest>
  extends AbstractQTestApiRequestMarshaller<T> {
  //~ class members ===========================================================
  /**
   * Validate test-case identifier.
   *
   * @param moduleId the given test-case identifier to validate.
   * @throws AuthServiceException if an error occurs during validating test-case identifier.
   */
  static void validateTestCaseId(Long moduleId) throws AuthServiceException {
    validateId(moduleId, "Invalid test-case id passed to marshall(...)");
  }

  /**
   * @return API path builder, used to build resource path.
   */
  protected StringBuilder createApiPathBuilder(Long projectId) {
    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(projectId));
    pathBuilder.append("/test-cases");
    return pathBuilder;
  }

  protected Request createJsonRequest(T requestType, String requestAction, HttpMethod requestMethod) {
    return super.createJsonRequest(requestType, "TestDesignService", requestAction, requestMethod);
  }
}
