package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.design.model.AutomationTestCase;

/**
 * AutomationTestCaseJsonUnmarshaller
 *
 * @author Thong Nguyen
 * @version $Id AutomationTestCaseJsonUnmarshaller 2015-03-14 22:51:30z thongnguyen $
 * @since 1.0
 */
public class AutomationTestCaseJsonUnmarshaller extends AbstractUnmarshaller<AutomationTestCase, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static AutomationTestCaseJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AutomationTestCaseJsonUnmarshaller getInstance() {
    if (instance == null) instance = new AutomationTestCaseJsonUnmarshaller();
    return instance;
  }

  @Override
  public AutomationTestCase parse(String data) throws Exception {
    return JsonMapper.parseJson(data, AutomationTestCase.class);
  }
}
