package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.MoveTestCaseRequest;

/**
 * MoveTestCaseRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestCaseRequestMarshaller 2015-06-03 17:41:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveTestCaseRequestMarshaller
  extends AbstractTestCaseRequestMarshaller<MoveTestCaseRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(MoveTestCaseRequest testCaseRequest) throws Exception {
    // validate testcase request.
    testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
    validateProjectId(testCaseRequest.getProjectId());
    validateTestCaseId(testCaseRequest.getTestCaseId());
    validateId(testCaseRequest.getModuleId(), "Invalid module identifier passed to marshall(...)");

    // create request.
    Request request = createJsonRequest(testCaseRequest, "MoveTestCase", HttpMethod.PUT);

    StringBuilder pathBuilder = new StringBuilder(createApiBasePathWithProject(testCaseRequest.getProjectId()));
    pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId());
    request.setResourcePath(pathBuilder.toString());

    // set request parameter.
    request.addParameter("parentId", String.valueOf(testCaseRequest.getTestCaseId()));

    request.setContent(new StringInputStream("{}"));
    return request;
  }
}
