package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * CreateTestCycleRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestCycleRequest 2015-05-28 16:11:30z dzungvnguyen $
 * @since 1.0
 */
public class CreateTestCycleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private TestCycle testCycle;
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the create test-cycle request instance.
   */
  public CreateTestCycleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the given artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   * @return current create test cycle request instance.
   */
  public CreateTestCycleRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level value.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   * @return the create test cycle request.
   */
  public CreateTestCycleRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  /**
   * @return the test cycle.
   */
  public TestCycle getTestCycle() {
    return testCycle;
  }

  /**
   * Sets the test-cycle.
   *
   * @param testCycle the given test-cycle instance.
   */
  public void setTestCycle(TestCycle testCycle) {
    this.testCycle = testCycle;
  }

  /**
   * Sets the test-cycle instance.
   *
   * @param testCycle the given test-cycle instance to set.
   * @return the create test cycle request instance.
   */
  public CreateTestCycleRequest withTestCycle(TestCycle testCycle) {
    setTestCycle(testCycle);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateTestCycleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", testCycle=").append(testCycle);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append('}');
    return sb.toString();
  }
}
