package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestRunRequest 2014-10-24 16:24:30z dungvnguyen $
 * @since 1.0
 */
public class GetTestRunRequest<T extends GetTestRunRequest> extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  /**
   * @deprecated since version 1.4.2
   */
  @Deprecated
  public static final int EXPAND_TESTCASE = 1;
  /**
   * @deprecated since version 1.4.2
   */
  @Deprecated
  public static final int EXPAND_TESTSTEPS = 2;

  protected Long testRunId;
  protected int expandOption;
  protected boolean expandTestCase;
  protected boolean expandTestStep;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   * @return the current {@link GetTestRunRequest} object.
   */
  public T withProjectId(Long projectId) {
    setProjectId(projectId);
    return (T)this;
  }

  /**
   * @return the test run id.
   */
  public Long getTestRunId() {
    return testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   */
  public void setTestRunId(Long testRunId) {
    this.testRunId = testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   * @return the current {@link GetTestRunRequest} object.
   */
  public T withTestRunId(Long testRunId) {
    setTestRunId(testRunId);
    return (T)this;
  }

  public boolean hasExpandOption() {
    return expandTestCase || expandTestStep;
  }

  /**
   * @return the expand option.
   */
  public int getExpandOption() {
    return expandOption;
  }

  /**
   * Sets the given expand option.
   *
   * @param expandOption the given expand option to set.
   */
  public void setExpandOption(int expandOption) {
    this.expandOption = expandOption;
    expandTestCase = (expandOption & EXPAND_TESTCASE) == EXPAND_TESTCASE;
    expandTestStep = (expandOption & EXPAND_TESTSTEPS) == EXPAND_TESTSTEPS;
  }

  /**
   * Sets the given expand option.
   *
   * @param expandOption the given expand option to set.
   * @return current request instance.
   */
  public T withExpandOption(int expandOption) {
    setExpandOption(expandOption);
    return (T)this;
  }

  public boolean isExpandTestCase() {
    return expandTestCase;
  }

  public T setExpandTestCase(boolean expandTestCase) {
    this.expandTestCase = expandTestCase;
    return (T)this;
  }

  public T withExpandTestCase(boolean expandTestCase) {
    this.expandTestCase = expandTestCase;
    return (T)this;
  }

  public boolean isExpandTestStep() {
    return expandTestStep;
  }

  public T setExpandTestStep(boolean expandTestStep) {
    this.expandTestStep = expandTestStep;
    return (T)this;
  }

  public T withExpandTestStep(boolean expandTestStep) {
    this.expandTestStep = expandTestStep;
    return (T)this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testRunId=").append(testRunId);
    sb.append(", expandTestCase=").append(expandTestCase);
    sb.append(", expandTestStep=").append(expandTestStep);
    sb.append('}');
    return sb.toString();
  }
}
