package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * MoveTestRunRequest
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestRunRequest 2015-05-31 23:29:30z dzungvnguyen $
 * @since 1.0
 */
public class MoveTestRunRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testRunId;
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   * @return the current {@link MoveTestRunRequest} object.
   */
  public MoveTestRunRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test run id.
   */
  public Long getTestRunId() {
    return testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   */
  public void setTestRunId(Long testRunId) {
    this.testRunId = testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   * @return the current {@link MoveTestRunRequest} object.
   */
  public MoveTestRunRequest withTestRunId(Long testRunId) {
    setTestRunId(testRunId);
    return this;
  }

  /**
   * @return the test artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the test cycle identifier where to fetch the test suites.
   *
   * @param artifactId the given test artifact identifier.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier where to fetch the test suites.
   *
   * @param artifactId the given artifact identifier to set.
   * @return the move test-run request instance.
   */
  public MoveTestRunRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public MoveTestRunRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("MoveTestRunRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", testRunId=").append(testRunId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append('}');
    return sb.toString();
  }
}
