package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * MoveTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestSuiteRequest 2015-05-29 17:29:30z dzungvnguyen $
 * @since 1.0
 */
public class MoveTestSuiteRequest extends UpdateTestSuiteRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;

  //~ class members ===========================================================
  /**
   * Sets project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current move test-suite request instance.
   */
  public MoveTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier.
   * @return the current move test-suite request instance.
   */
  public MoveTestSuiteRequest withTestSuiteId(Long testSuiteId) {
    setTestSuiteId(testSuiteId);
    return this;
  }

  /**
   * Sets the test-suite instance.
   *
   * @param testSuite the given test-suite instance to set.
   * @return the current move test-suite request instance.
   */
  public MoveTestSuiteRequest withTestSuite(TestSuite testSuite) {
    setTestSuite(testSuite);
    return this;
  }

  /**
   * @return the given artifact identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier.
   *
   * @param artifactId the given artifact identifier to set.
   * @return current move test suite request instance.
   */
  public MoveTestSuiteRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level value.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets artifact level value.
   *
   * @param artifactLevel the given artifact level value.
   * @return the move test suite request.
   */
  public MoveTestSuiteRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("MoveTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append(", testSuiteId=").append(testSuiteId);
    sb.append(", testSuite=").append(testSuite);
    sb.append('}');
    return sb.toString();
  }
}
