package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.GetLastLogRequest;


/**
 * GetLastLogRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetLastLogRequestMarshaller 2014-10-24 17:04:30z dungvnguyen $
 * @since 1.0
 */
public final class GetLastLogRequestMarshaller extends AbstractMarshaller<Request, GetLastLogRequest> {

  @Override
  protected void validateRequest(GetLastLogRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }

    // validate project id.
    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }

    // validate test-run id.
    if (in.getTestRunId() == null || in.getTestRunId() <= 0) {
      throw new AuthClientException("Invalid test run id passed to marshall(...)");
    }

    // validate automation test log.
    if (in.getExpandOption() < 0 || in.getExpandOption() > 3) {
      throw new AuthClientException("Invalid expand option passed to marshall(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "TestExecutionService";
  }

  @Override
  protected String getActionName() {
    return "GetLastLog";
  }

  @Override
  protected String getContent(GetLastLogRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(GetLastLogRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/test-runs/")
      .append(in.getTestRunId().longValue())
      .append("/test-logs/last-run");

    // build expand option.
    if (in.hasExpandOption()) {
      StringBuilder queryBuilder = new StringBuilder();
      if (in.isExpandTestCase()) {
        queryBuilder.append("testcase");
      }

      if (in.isExpandTestStep()) {
        if (queryBuilder.length() > 0) queryBuilder.append(",");
        queryBuilder.append("teststeplog.teststep");
      }

      if (queryBuilder.length() > 0) {
        rpBuilder.append("?expand=").append(queryBuilder.toString());
      }
    }
    return rpBuilder;
  }
}
