package org.qas.qtest.api.services.execution.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestRun;

import java.util.List;

/**
 * ListTestRunJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListTestRunJsonUnmarshaller 2014-05-06 16:17:30z dungvnguyen $
 * @since 1.0
 */
public final class ListTestRunJsonUnmarshaller extends AbstractUnmarshaller<List<TestRun>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListTestRunJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListTestRunJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListTestRunJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<TestRun> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<TestRun>>() {
    });
  }
}
