package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.MoveTestCycleRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * MoveTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestCycleRequestMarshaller 2015-05-29 07:38:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveTestCycleRequestMarshaller
  extends AbstractTestCycleRequestMarshaller<MoveTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(MoveTestCycleRequest testCycleRequest) throws Exception {
    // validate input.
    testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
    validateProjectId(testCycleRequest.getProjectId());

    // resolve and validate test cycle identifier.
    Long testCycleId = (testCycleRequest.getTestCycleId() != null
      ? testCycleRequest.getTestCycleId()
      : (testCycleRequest.getTestCycle() == null ? null : testCycleRequest.getTestCycle().getId())
    );
    validateTestCycleId(testCycleId);

    ApiPreconditions.notNull(testCycleRequest.getArtifactLevel(), "Invalid artifact level passed to marshall(...)");
    validateArtifactLevel(testCycleRequest.getArtifactLevel());
    validateArtifact(testCycleRequest.getArtifactLevel(), testCycleRequest.getArtifactId());

    // create update request.
    Request request = createJsonRequest(testCycleRequest, "MoveTestCycle", HttpMethod.PUT);

    // set resource path.
    StringBuilder builder = createApiPathBuilder(testCycleRequest.getProjectId());
    builder.append('/').append(testCycleId.longValue());
    request.setResourcePath(builder.toString());

    // set request parameter.
    if (testCycleRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testCycleRequest.getArtifactId()));
    } else {
      request.addParameter("parentId", "0");
    }
    request.addParameter("parentType", testCycleRequest.getArtifactLevel().getQueryParam());

    // set resource content.
    if (testCycleRequest.getTestCycle() != null) {
      request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));
    }

    return request;
  }
}
