package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.model.ArtifactLevel;
import org.qas.qtest.api.services.execution.model.MoveTestRunRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * MoveTestRunRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id MoveTestRunRequestMarshaller 2015-05-31 23:33:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveTestRunRequestMarshaller
  extends AbstractTestRunRequestMarshaller<MoveTestRunRequest>{
  //~ class members ===========================================================
  @Override
  public Request marshall(MoveTestRunRequest testRunRequest) throws Exception {
    // validate test-run request.
    testRunRequest = ApiPreconditions.notNull(testRunRequest);
    validateProjectId(testRunRequest.getProjectId());
    validateTestRunId(testRunRequest.getTestRunId());
    validateArtifactLevel(testRunRequest.getArtifactLevel());
    validateArtifact(testRunRequest.getArtifactLevel(), testRunRequest.getArtifactId());

    // create move test-run request.
    Request request = createJsonRequest(testRunRequest, "MoveTestRun", HttpMethod.PUT);

    // set resource path.
    StringBuilder pathBuilder = createApiPathBuilder(testRunRequest.getProjectId());
    pathBuilder.append("/").append(testRunRequest.getTestRunId());
    request.setResourcePath(pathBuilder.toString());

    // set resource path parameter.
    if (testRunRequest.getArtifactLevel() != ArtifactLevel.ROOT) {
      request.addParameter("parentId", String.valueOf(testRunRequest.getArtifactId()));
    } else {
      request.addParameter("parentId", "0");
    }
    request.addParameter("parentType", testRunRequest.getArtifactLevel().getQueryParam());

    // set request payload.
    request.setContent(new StringInputStream("{}"));
    return request;
  }
}
