package org.qas.qtest.api.services.host;

import java.util.List;
import java.util.concurrent.Future;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.services.host.model.*;

/**
 * HostServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id HostServiceAsync 2015-03-14 19:10:30z dzungvnguyen $
 * @since 1.0
 */
public interface HostServiceAsync extends HostService {
  /**
   * Register the automation host to qTest service.
   *
   * @param automationHostRequest the given register automation host request.
   * @return the automation host information.
   * @throws org.qas.api.AuthClientException if an error occurs during registering automation host.
   */
  Future<AutomationHost> registerAutomationHostAsync(CreateAutomationHostRequest automationHostRequest)
    throws AuthClientException;

  /**
   * Register the automation host to qTest service.
   *
   * @param automationHostRequest the given register automation host request.
   * @param asyncHandler          callback handler for events in the life-cycle of the request.
   *                              Users could provide the implementation of the for callback
   *                              methods in this interface to process the operation result or
   *                              handle the exception.
   * @return the automation host information.
   * @throws org.qas.api.AuthClientException if an error occurs during registering automation host.
   */
  Future<AutomationHost> registerAutomationHostAsync(CreateAutomationHostRequest automationHostRequest,
                                                     AsyncHandler<CreateAutomationHostRequest, AutomationHost> asyncHandler)
    throws AuthClientException;

  /**
   * Register the automation agent to qTest service.
   *
   * @param automationAgentRequest the given register agent request to send to qTest.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during registering automation agent.
   */
  Future<AutomationAgent> registerAutomationAgentAsync(CreateAutomationAgentRequest automationAgentRequest)
    throws AuthClientException;

  /**
   * Register the automation agent to qTest service.
   *
   * @param automationAgentRequest the given register agent request to send to qTest.
   * @param asyncHandler           callback handler for events in the life-cycle of the request.
   *                               Users could provide the implementation of the for callback
   *                               methods in this interface to process the operation result or
   *                               handle the exception.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during registering automation agent.
   */
  Future<AutomationAgent> registerAutomationAgentAsync(CreateAutomationAgentRequest automationAgentRequest,
                                                       AsyncHandler<CreateAutomationAgentRequest, AutomationAgent> asyncHandler)
    throws AuthClientException;

  /**
   * Get all runnable jobs from qTest server in a period
   *
   * @param listJobRequest the given get list jobs request to sent to server.
   * @return the list of job execution.
   * @throws AuthClientException if an error occurs during list job.
   */
  Future<List<Job>> listJobsAsync(ListJobRequest listJobRequest)
    throws AuthClientException;

  /**
   * Get all jobs to execute.
   *
   * @param listJobRequest the given list job request to send to qTest.
   * @param asyncHandler   callback handler for events in the life-cycle of the request.
   *                       Users could provide the implementation of the for callback
   *                       methods in this interface to process the operation result or
   *                       handle the exception.
   * @return the list of jobs.
   * @throws AuthClientException if an error occurs during requesting.
   */
  Future<List<Job>> listJobsAsync(ListJobRequest listJobRequest,
                                  AsyncHandler<ListJobRequest, List<Job>> asyncHandler)
    throws AuthClientException;

  /**
   * Send ping host to server.
   *
   * @param pingHostRequest the given ping host request to send to server.
   * @return the pong message.
   * @throws AuthClientException if an error occurs during send ping request to server.
   */
  Future<PongMessage> pingHostAsync(PingAutomationHostRequest pingHostRequest)
    throws AuthClientException;

  /**
   * Send ping host to server.
   *
   * @param pingHostRequest the given ping host request to send to server.
   * @param asyncHandler    callback handler for events in the life-cycle of the request.
   *                        Users could provide the implementation of the for callback
   *                        methods in this interface to process the operation result or
   *                        handle the exception.
   * @return the pong message.
   * @throws AuthClientException if an error occurs during send ping request to server.
   */
  Future<PongMessage> pingHostAsync(PingAutomationHostRequest pingHostRequest,
                                    AsyncHandler<PingAutomationHostRequest, PongMessage> asyncHandler)
    throws AuthClientException;


  /**
   * Update the automation agent to qTest service.
   *
   * @param automationAgentRequest the given update agent request to send to qTest.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during updating automation agent.
   */
  Future<AutomationAgent> updateAutomationAgentAsync(UpdateAutomationAgentRequest automationAgentRequest)
    throws AuthClientException;

  /**
   * Update the automation agent to qTest service.
   *
   * @param automationAgentRequest the given update agent request to send to qTest.
   * @param asyncHandler           callback handler for events in the life-cycle of the request.
   *                               Users could provide the implementation of the for callback
   *                               methods in this interface to process the operation result or
   *                               handle the exception.
   * @return the automation agent instance.
   * @throws AuthClientException if an error occurs during updating automation agent.
   */
  Future<AutomationAgent> updateAutomationAgentAsync(UpdateAutomationAgentRequest automationAgentRequest,
                                                     AsyncHandler<UpdateAutomationAgentRequest, AutomationAgent> asyncHandler)
    throws AuthClientException;

  /**
   * Activate or deactivate the automation agent to qTest service.
   *
   * @param activateAgentRequest the given activate agent request to send to qTest.
   * @return Future
   * @throws AuthClientException if an error occurs during activating automation agent.
   */
  Future<Void> activateAutomationAgentAsync(ActivateAutomationAgentRequest activateAgentRequest)
    throws AuthClientException;

  /**
   * Activate or Deactivate the automation agent to qTest service.
   *
   * @param activateAgentRequest the given activate agent request to send to qTest.
   * @param asyncHandler         callback handler for events in the life-cycle of the request.
   *                             Users could provide the implementation of the for callback
   *                             methods in this interface to process the operation result or
   *                             handle the exception.
   * @return Future
   * @throws AuthClientException if an error occurs during activating automation agent.
   */
  Future<Void> activateAutomationAgentAsync(ActivateAutomationAgentRequest activateAgentRequest,
                                            AsyncHandler<ActivateAutomationAgentRequest, Void> asyncHandler)
    throws AuthClientException;

  /**
   * Update job instance status
   *
   * @param updateJobStatusRequest the given update job request.
   * @return Future
   * @throws AuthServiceException if an error occurs during updating job status.
   */
  Future<Void> updateJobStatusAsync(UpdateJobStatusRequest updateJobStatusRequest) throws AuthServiceException;

  /**
   * Update job instance status
   *
   * @param updateJobStatusRequest the given update job request.
   * @param asyncHandler           callback handler for events in the life-cycle of the request.
   *                               Users could provide the implementation of the for callback
   *                               methods in this interface to process the operation result or
   *                               handle the exception.
   * @return Future
   * @throws AuthServiceException if an error occurs during updating job status.
   */
  Future<Void> updateJobStatusAsync(UpdateJobStatusRequest updateJobStatusRequest,
                                    AsyncHandler<UpdateJobStatusRequest, Void> asyncHandler) throws AuthServiceException;

  /**
   * delete automation agent
   *
   * @param deleteAutomationAgentRequest deleteAutomationAgentRequest
   * @return Future
   * @throws AuthClientException if an error occurs during updating automation agent.
   */
  Future<Void> deleteAutomationAgentAsync(DeleteAutomationAgentRequest deleteAutomationAgentRequest)
    throws AuthServiceException;

  /**
   * delete automation host
   *
   * @param deleteAutomationAgentRequest deleteAutomationAgentRequest
   * @param asyncHandler                 callback handler for events in the life-cycle of the request.
   *                                     Users could provide the implementation of the for callback
   *                                     methods in this interface to process the operation result or
   *                                     handle the exception.
   * @return Future
   * @throws AuthClientException if an error occurs during updating automation agent.
   */
  Future<Void> deleteAutomationAgentAsync(DeleteAutomationAgentRequest deleteAutomationAgentRequest,
                                          AsyncHandler<DeleteAutomationAgentRequest, Void> asyncHandler) throws AuthServiceException;
}
