package org.qas.qtest.api.services.plan.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.FieldValue;
import org.qas.qtest.api.internal.model.QTestBaseModel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Build
 *
 * @author Dzung Nguyen
 * @version $Id Build 2014-07-18 12:01:30z dungvnguyen $
 * @since 1.0
 */
public class Build extends QTestBaseModel<Build> {

  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("pid")
  private String pid;

  @JsonProperty("release")
  private Release release;

  @JsonProperty("properties")
  private List<FieldValue> fieldValues;

  public Build() {
  }

  /**
   * @return the build identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the build identifier.
   *
   * @param id the given build identifier.
   */
  public Build setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the build identifier and return itself.
   *
   * @param id the given build identifier value to set.
   * @return the build instance.
   */
  public Build withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the build name.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the build name.
   *
   * @param name the given build name to set.
   */
  public Build setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Sets the build name.
   *
   * @param name the given build name to set.
   * @return current build instance.
   */
  public Build withName(String name) {
    return setName(name);
  }

  /**
   * @return the build pid value.
   */
  public String getPid() {
    return pid;
  }

  /**
   * Sets the build pid value.
   *
   * @param pid the given build pid value to set.
   */
  public Build setPid(String pid) {
    this.pid = pid;
    return this;
  }

  /**
   * Sets the build pid value.
   *
   * @param pid the given build pid value to set.
   * @return the build instance.
   */
  public Build withPid(String pid) {
    setPid(pid);
    return this;
  }

  /**
   * the list of field value objects.
   *
   * @return
   */
  public List<FieldValue> getFieldValues() {
    if (null == fieldValues) {
      return Collections.emptyList();
    }
    return fieldValues;
  }

  /**
   * Sets the list of field value objects.
   *
   * @param values the given field value objects to set.
   */
  public Build setFieldValues(List<FieldValue> values) {
    this.fieldValues = new ArrayList<>();
    if (null == values) {
      return this;
    }
    for (FieldValue fieldValue : values) {
      addFieldValue(fieldValue);
    }
    return this;
  }

  /**
   * Sets the list of field value objects.
   *
   * @param values the given field value objects to set.
   * @return the build instance.
   */
  public Build withFieldValues(List<FieldValue> values) {
    setFieldValues(values);
    return this;
  }

  /**
   * Adds the property value to build and return itself.
   *
   * @param value the given field value to add.
   * @return the build instance.
   */
  public Build addFieldValue(FieldValue value) {
    if (value == null || value.getValue() == null) {
      return this;
    }
    if (fieldValues == null) {
      fieldValues = new ArrayList<>();
    }
    fieldValues.add(value);
    return this;
  }

  public Release getRelease() {
    return release;
  }

  public Build setRelease(Release release) {
    this.release = release;
    return this;
  }

  public Build withRelease(Release release) {
    this.release = release;
    return this;
  }

  @Override
  public Build clone() {
    Build that = new Build();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "build";
  }
}
