package org.qas.qtest.api.services.plan.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.FieldValue;
import org.qas.qtest.api.internal.model.QTestBaseModel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Release
 *
 * @author Dzung Nguyen
 * @version $Id Release 2014-07-18 11:53:30z dungvnguyen $
 * @since 1.0
 */
public class Release extends QTestBaseModel<Release> {
  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  @JsonProperty("pid")
  private String pid;

  @JsonProperty("properties")
  private List<FieldValue> fieldValues;

  public Release() {
  }

  /**
   * @return the release identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the release identifier.
   *
   * @param id the given release identifier.
   */
  public Release setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the release identifier and return itself.
   *
   * @param id the given release identifier value to set.
   * @return the release instance.
   */
  public Release withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the release name.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the release name.
   *
   * @param name the given release name to set.
   */
  public Release setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Sets the release name.
   *
   * @param name the given release name to set.
   * @return current build instance.
   */
  public Release withName(String name) {
    setName(name);
    return this;
  }

  /**
   * @return the release pid value.
   */
  public String getPid() {
    return pid;
  }

  /**
   * Sets the release pid value.
   *
   * @param pid the given release pid value to set.
   */
  public Release setPid(String pid) {
    this.pid = pid;
    return this;
  }

  /**
   * Sets the release pid value.
   *
   * @param pid the given release pid value to set.
   * @return the release instance.
   */
  public Release withPid(String pid) {
    setPid(pid);
    return this;
  }

  /**
   * @return the list of field value objects.
   */
  public List<FieldValue> getFieldValues() {
    if (fieldValues == null) {
      return Collections.emptyList();
    }
    return fieldValues;
  }

  /**
   * Sets the list of field value objects.
   *
   * @param values the given field value objects to set.
   */
  public Release setFieldValues(List<FieldValue> values) {
    this.fieldValues = new ArrayList<>();
    if (null == values) {
      return this;
    }
    for (FieldValue fieldValue : values) {
      addFieldValue(fieldValue);
    }
    return this;
  }

  /**
   * Sets the list of field value objects.
   *
   * @param values the given field value objects to set.
   * @return the release instance.
   */
  public Release withFieldValues(List<FieldValue> values) {
    setFieldValues(values);
    return this;
  }

  /**
   * Adds the property value to release and return itself.
   *
   * @param value the given field value to add.
   * @return the release instance.
   */
  public Release addFieldValue(FieldValue value) {
    if (value == null || value.getValue() == null) {
      return this;
    }
    if (fieldValues == null) {
      fieldValues = new ArrayList<>();
    }
    fieldValues.add(value);
    return this;
  }

  @Override
  public Release clone() {
    Release that = new Release();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "release";
  }
}
