package org.qas.qtest.api.services.plan.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.plan.model.Release;

/**
 * ReleaseJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ReleaseJsonUnmarshaller 2014-07-18 13:02:30z dungvnguyen $
 * @since 1.0
 */
public class ReleaseJsonUnmarshaller extends AbstractUnmarshaller<Release, JsonUnmarshallerContext> {
  // ~ class properties =======================================================
  private static ReleaseJsonUnmarshaller instance;

  // ~ class members ==========================================================
  public static ReleaseJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ReleaseJsonUnmarshaller();
    }
    return instance;
  }

  @Override
  public Release parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Release.class);
  }
}
