package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.LinkTestCaseRequirementRequest;

/**
 * LinkTestCaseRequirementRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id LinkTestCaseRequirementRequestMarshaller 2014-05-19 16:10:30z dungvnguyen $
 * @since 1.0
 */
public final class LinkTestCaseRequirementRequestMarshaller extends AbstractMarshaller<Request, LinkTestCaseRequirementRequest> {

  @Override
  protected void validateRequest(LinkTestCaseRequirementRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }

    if (in.getProjectId() == null || in.getProjectId() <= 0L) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }

    if (in.getRequirementId() == null || in.getRequirementId() <= 0L) {
      throw new AuthClientException("Invalid requirement id passed to marshall(...)");
    }

    if (in.getTestCaseIds() == null || in.getTestCaseIds().isEmpty()) {
      throw new AuthClientException("Invalid testcase ids passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, LinkTestCaseRequirementRequest in) {
    // set request method and request path.
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "ProjectService";
  }

  @Override
  protected String getActionName() {
    return "LinkTestCaseRequirement";
  }

  @Override
  protected String getContent(LinkTestCaseRequirementRequest in) throws Exception {
    JsonObject requestBody = new JsonObject();
    requestBody.put("requirement_id", in.getRequirementId());

    JsonArray testCases = new JsonArray();
    for (Long testCaseId : in.getTestCaseIds()) {
      testCases.put(testCaseId);
    }
    requestBody.put("testcase_ids", testCases);
    return requestBody.toString();
  }

  @Override
  protected StringBuilder getResourcePath(LinkTestCaseRequirementRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/" + in.getProjectId() + "/req-tc-links");
  }
}
