package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.ListProjectRequest;

/**
 * ListProjectRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListProjectRequestMarshaller 2014-03-27 18:42:30z dungvnguyen $
 * @since 1.0
 */
public final class ListProjectRequestMarshaller extends AbstractMarshaller<Request, ListProjectRequest> {

  @Override
  protected void validateRequest(ListProjectRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
  }

  @Override
  protected void build(Request request, ListProjectRequest in) {
    request.setHttpMethod(HttpMethod.GET);
    if (in.isAssignOnly()) {
      request.addParameter("assigned", "true");
    }
  }

  @Override
  protected String getServiceName() {
    return "ProjectService";
  }

  @Override
  protected String getActionName() {
    return "ListProject";
  }

  @Override
  protected String getContent(ListProjectRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(ListProjectRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects");
  }
}
