package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.ListUserPermissionsRequest;

/**
 * ListUserPermissionsRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListUserPermissionsRequestMarshaller 2014-12-22 14:49:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListUserPermissionsRequestMarshaller extends AbstractMarshaller<Request, ListUserPermissionsRequest> {

  @Override
  protected void validateRequest(ListUserPermissionsRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "ProjectService";
  }

  @Override
  protected String getActionName() {
    return "ListUserPermissions";
  }

  @Override
  protected String getContent(ListUserPermissionsRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(ListUserPermissionsRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/user-profiles/current");
  }
}
