package org.qas.qtest.api.services.requirement;

import org.qas.api.AuthServiceException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.services.project.model.GetFieldsRequest;
import org.qas.qtest.api.services.requirement.model.CreateRequirementRequest;
import org.qas.qtest.api.services.requirement.model.GetRequirementFieldsRequest;
import org.qas.qtest.api.services.requirement.model.Requirement;

import java.util.List;
import java.util.concurrent.Future;

/**
 * RequirementServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id RequirementServiceAsync 2014-05-19 12:21:30z dungvnguyen $
 * @since 1.0
 */
public interface RequirementServiceAsync extends RequirementService {
  /**
   * Gets the requirement fields in project.
   *
   * @param getRequirementFieldsRequest the given get requirement field request information.
   * @return the list of requirement fields.
   * @throws AuthServiceException if an error occurs during getting requirement fields.
   * @deprecated replace with {@link org.qas.qtest.api.services.project.ProjectServiceAsync#getFieldsAsync(GetFieldsRequest)}
   */
  @Deprecated
  Future<List<Field>> getRequirementFieldsAsync(GetRequirementFieldsRequest getRequirementFieldsRequest)
      throws AuthServiceException;

  /**
   * Gets the requirement fields in project.
   *
   * @param getRequirementFieldsRequest the given get requirement field request information.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the list of requirement fields.
   * @throws AuthServiceException if an error occurs during getting requirement fields.
   * @deprecated replace with {@link org.qas.qtest.api.services.project.ProjectServiceAsync#getFieldsAsync(GetFieldsRequest, AsyncHandler)}
   */
  @Deprecated
  Future<List<Field>> getRequirementFieldsAsync(GetRequirementFieldsRequest getRequirementFieldsRequest,
                                                AsyncHandler<GetRequirementFieldsRequest, List<Field>> asyncHandler)
      throws AuthServiceException;

  /**
   * Creates requirement object.
   * @param createRequirementRequest the given {@link CreateRequirementRequest create requirement request}
   *                                 instance that hold the requirement information.
   * @return the requirement object.
   * @throws AuthServiceException if an error occurs during creating requirement object.
   */
  Future<Requirement> createRequirementAsync(CreateRequirementRequest createRequirementRequest)
    throws AuthServiceException;

  /**
   * Creates requirement object.
   * @param createRequirementRequest the given {@link CreateRequirementRequest create requirement request}
   *                                 instance that hold the requirement information.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the requirement object.
   * @throws AuthServiceException if an error occurs during creating requirement object.
   */
  Future<Requirement> createRequirementAsync(CreateRequirementRequest createRequirementRequest,
                                             AsyncHandler<CreateRequirementRequest, Requirement> asyncHandler)
      throws AuthServiceException;

  /**
   * Create the requirement comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest create requirement request}
   *                                   instance that hold the requirement request information.
   * @return the requirement information.
   * @throws AuthServiceException if an error occurs during creating requirement comment.
   */
  Future<Requirement> addCommentAsync(CreateObjectCommentRequest createObjectCommentRequest)
      throws AuthServiceException;

  /**
   * Create the requirement comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest create requirement request}
   *                                   instance that hold the requirement request information.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the requirement information.
   * @throws AuthServiceException if an error occurs during creating requirement comment.
   */
  Future<Requirement> addCommentAsync(CreateObjectCommentRequest createObjectCommentRequest,
                                      AsyncHandler<CreateObjectCommentRequest, Requirement> asyncHandler)
      throws AuthServiceException;
}
